/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HoursCounterParameter;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.HoursCounterBlock;
import DE.siemens.ad.logo.model.hardware.Logo6;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.ExtendedDefaultTableModel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class HardwareHoursCounterPanel
extends DataInputPanel {
    public HardwareHoursCounterPanel() throws ExceptionAlreadyHandledException, ProgramException {
        this.initialize();
    }

    private JTable createTable() throws ExceptionAlreadyHandledException, ProgramException {
        JTable result;
        block20: {
            result = null;
            DataTransfer dt = null;
            int STARTADRESS = 62464;
            Log.printStartSequence("log.msg.readHardwareHoursCounter", "Reading Operating Hours Counter");
            try {
                dt = DataTransfer.openConnection(true);
                if (!dt.isTransmissionPossible((JComponent)this.getParent())) {
                    throw new ExceptionAlreadyHandledException();
                }
                Hardware hw = dt.getHardware();
                if (hw.supports("readFunctionParameter")) {
                    if (!hw.supports("readHourCounterWithoutCopy")) {
                        int[] data = dt.readByteArray(992, 31);
                        for (int i = 0; i < data.length; ++i) {
                            dt.writeByte(62464 + i, data[i]);
                        }
                    }
                    WiringDiagram wd = null;
                    ((Logo)hw).clearPasswordOnLogo(dt);
                    if (hw instanceof Logo6) {
                        ((Logo6)hw).setNeedmessageInfo(false);
                    }
                    wd = hw.uploadProgram(dt);
                    ((Logo)hw).setPasswordOnLogo(dt);
                    ArrayList<Block> blockList = new ArrayList<Block>();
                    Enumeration allBlocks = wd.getBlocksExpansion().elements();
                    while (allBlocks.hasMoreElements()) {
                        Block block = (Block)allBlocks.nextElement();
                        if (!(block instanceof HoursCounterBlock)) continue;
                        blockList.add(block);
                    }
                    int nrOfBlocks = blockList.size();
                    if (nrOfBlocks == 0) {
                        String s = Language.getString("error.hardware.noHoursCounter", "No Operating Hours Counter found");
                        Log.println(s);
                        new LogoError(this, s).display();
                        throw new ExceptionAlreadyHandledException();
                    }
                    ParameterItemList parameterItemsOrg = ((Block)blockList.get(0)).getParameter().getParameterItems();
                    ParameterItemList parameterItems = new ParameterItemList(parameterItemsOrg.getParameterClass(), 3);
                    for (int i = 0; i < 3; ++i) {
                        parameterItems.add(parameterItemsOrg.get(i));
                    }
                    String[] paramNames = new String[parameterItems.size()];
                    Iterator parameterItemIterator = parameterItems.iterator();
                    int index = 0;
                    while (parameterItemIterator.hasNext()) {
                        ParameterItem parameterItem = (ParameterItem)parameterItemIterator.next();
                        paramNames[index++] = parameterItem.getLocalisedName();
                    }
                    Object[] columnNames = new String[paramNames.length + 1];
                    columnNames[0] = Language.getString("error.util.blockNumber", "BlockNumber");
                    System.arraycopy(paramNames, 0, columnNames, 1, paramNames.length);
                    Object[][] data = new Object[nrOfBlocks][columnNames.length];
                    for (int i = 0; i < nrOfBlocks; ++i) {
                        Block block = (Block)blockList.get(i);
                        HoursCounterParameter param = (HoursCounterParameter)block.getParameter();
                        int prgLine = ((Logo)hw).getLinkerToHardware().convertToPrgLine(block.getNumber());
                        int opcode = block.getOpcode(hw, 0);
                        data[i][0] = wd.getOutestBlock(block).getNumberString();
                        if (hw instanceof Logo6) {
                            data[i][1] = this.minToHour(param.getMI_Minute());
                            int mn = Integer.valueOf(((Logo)hw).uploadFunctionParameter(dt, prgLine, opcode, 4));
                            data[i][2] = this.minToHour(mn);
                            int ot = Integer.valueOf(((Logo)hw).uploadFunctionParameter(dt, prgLine, opcode, 5));
                            data[i][3] = this.minToHour(ot);
                        } else {
                            data[i][1] = String.valueOf(param.getMI_Minute() / 60);
                            data[i][2] = ((Logo)hw).uploadFunctionParameter(dt, prgLine, opcode, 1);
                            data[i][3] = ((Logo)hw).uploadFunctionParameter(dt, prgLine, opcode, 2);
                        }
                        StringBuffer temp = new StringBuffer();
                        temp.append(data[i][0]).append("\t").append(data[i][1]).append("\t").append(data[i][2]).append("\t").append(data[i][3]);
                        Log.println(temp.toString());
                    }
                    ExtendedDefaultTableModel tableModel = new ExtendedDefaultTableModel(data, columnNames);
                    tableModel.setProtected(true);
                    result = new JTable(tableModel);
                    result.setRowSelectionAllowed(false);
                    result.setAutoCreateColumnsFromModel(false);
                    break block20;
                }
                String s = Language.getString("error.hardware.functionNotSupported", "Operation not supported from %", hw.getLocalizedPath() + hw.getLocalizedName());
                Log.println(s);
                new LogoError(this, s, s).display();
                throw new ExceptionAlreadyHandledException();
            }
            catch (TransmissionFailedException e) {
                String s = Language.getString("error.com.transmissionError", "Transmission failed: %", e.getMessage());
                throw new ProgramException(s);
            }
            finally {
                if (dt != null) {
                    dt.closePort();
                    dt = null;
                }
            }
        }
        return result;
    }

    private String minToHour(int min) {
        return new StringBuffer().append(min / 60).append('h').append(min % 60).append('m').toString();
    }

    public Dimension getPreferredSize() {
        return new Dimension(430, 360);
    }

    public String getTitle() {
        return Language.getString("dialog.hardwareHoursCounter.title", "Operating Hours Counter");
    }

    private void handleException(Throwable exception) {
    }

    private void initialize() throws ExceptionAlreadyHandledException, ProgramException {
        try {
            this.setLayout(new BorderLayout());
            this.setSize(257, 186);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.setName(this.getTitle());
        this.add((Component)new JScrollPane(this.createTable()), "Center");
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            HardwareHoursCounterPanel aHardwareHoursCounterPanel = new HardwareHoursCounterPanel();
            frame.setContentPane(aHardwareHoursCounterPanel);
            frame.setSize(aHardwareHoursCounterPanel.getSize());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.setVisible(true);
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of DE.siemens.ad.logo.dialog.comp.DataInputPanel");
            exception.printStackTrace(System.out);
        }
    }
}

